#ifndef __CWindowIcon__
#define __CWindowIcon__

#include <Basics/CSystemString.hpp>
using Exponent::Basics::CSystemString;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CWindowIcon CWindowIcon.hpp
			 * @brief Represents a window icon - only applicable on PC
			 *
			 * @date 01/10/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CWindowIcon.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CWindowIcon : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				CWindowIcon();

				/**
				 * Construction
				 * @param resourceId The resource id of the icon to load
				 */
				CWindowIcon(const long resourceId);

				#ifdef WIN32
					/**
					 * Construction
					 * @param icon The icon to store
					 */
					CWindowIcon(HICON icon);
				#endif

				/**
				 * Destruction
				 */
				virtual ~CWindowIcon();

//	===========================================================================

				/**
				 * Assignment operator
				 * @param icon The icon to store
				 * @retval CWindowIcon& A reference to this
				 */
				CWindowIcon &operator = (const CWindowIcon &icon);

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Get the icon
					 * @retval HICON The windows icon 
					 */
					HICON getIcon() const;

					/**
					 * Set the icon to a new icon
					 * @param icon The icon to store
					 */
					void setIcon(HICON icon);
				/** @cond */
				#endif
				/** @endcond */

//	===========================================================================

				/**
				 * Load a new icon from a resource
				 * @param resourceId The resource id of the icon to load
				 */
				void loadIcon(const long resourceId);

				/**
				 * Load an icon from a path
				 * @param path The path to the icon
				 * @param resourceId The resource id of the icon
				 */
				void loadIcon(const CSystemString &path, const long resourceId = 0);

				/**
				 * Unload the current Icon
				 */
				void unloadIcon();

//	===========================================================================

			protected:

//	===========================================================================

				#ifdef WIN32
					HICON m_icon;				/**< windows icon */
				#endif
			};
		}
	}
}
#endif	// End of CIcon